<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet exclude-result-prefixes="hl7 xsi" version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:hl7="urn:hl7-org:v3"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="html"/>
	<xsl:template match="hl7:codeSystem">
		<html>
			<head>
				<title>
					<xsl:value-of select="hl7:name"/>
				</title>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
				<script type="text/javascript" src="../css/gs_sortable.js"/>
				<script type="text/javascript">
                    var TSort_Data = new Array ('codeList', 's', 's');
                    var TSort_Initial = 0;
                    var TSort_Classes = new Array ('plain', 'alternate');
                    tsRegister();
                </script>
				<link type="text/css" href="../css/nictiz.css" rel="stylesheet"/>
			</head>
			<body>
				<table width="100%">
					<tr>
						<td valign="bottom">
							<h1>
								<xsl:value-of select="hl7:name"/>
							</h1>
						</td>
						<td align="right">
							<div class="logo"/>
						</td>
					</tr>
				</table>
				<p/>
				<div class="content">
					<h2>
						<xsl:value-of select="hl7:code[1]/@codeSystem"/>
					</h2>
					<p/>
					<div class="level2">
						<xsl:value-of select="hl7:desc"/>
					</div>
					<p/>
					<table class="values" id="codeList">
						<thead>
							<tr>
								<th>Code</th>
								<th>Weergavenaam</th>
							</tr>
						</thead>

						<xsl:for-each select="hl7:code">
							<tr>
								<td>
									<xsl:value-of select="@code"/>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="hl7:originalText">
											<span title="{hl7:originalText}">
												<xsl:value-of select="@displayName"/>
											</span>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@displayName"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
